# -*- coding: utf-8 -*-
"""
Created on Wed Oct 07 12:00:53 2015

"""

# Overview
# --------
# create main module
# load inputs and parameters
# Setup other derived parameters
# Calculate concentrations in CalculateConcentrations module
# Plot graphs in PlotGraphs module
  
# create main module
from CMain import CMain
main_module = CMain()
from CAnalysis import CAnalysis

# run the analyses
for river_index in range(0,main_module.NumberOfRivers()):

    # create analysis and make it available for the other modules
    main_module.Analysis = CAnalysis()
    main_module.Analyses.append(main_module.Analysis)
    main_module.SetupModules()
    
    # load inputs into the analysis data structure for this river
    main_module.LoadDataInputs(river_index)
        
    # setup the discretised analysis
    main_module.SetupAnalysis()

    # print input parameters and derived parameters
    main_module.PrintToConsole()
    
    # Calculate concentrations in CalculateConcentrations module
    main_module.CalculateConcentrations()
    
    # plot concentration graphs
    main_module.PlotConcentrations() 
    
    # plot residuals 
    main_module.PlotResiduals()
    
#main_module.SaveAnalyses()



#==============================================================================
# 
# 
# #show domain 
# x_values = main_module.Analysis.Domain.X.InclusiveRange()
# y_values = main_module.Analysis.Domain.Y.InclusiveRange()
# time_values = main_module.Analysis.Domain.Time.InclusiveRange()
# y_index = main_module.Analysis.Domain.Y.MidIndex()
# y_mid_value = main_module.Analysis.Domain.Y.MidValue()
# 
# # Show concentrations in variable explorer 
# C_advection = main_module.Analysis.Models.AdvectionOnly.Concentrations
# C_longitudinal = main_module.Analysis.Models.ADELongitudinal.Concentrations
# C_transverse = main_module.Analysis.Models.ADETransverse.Concentrations
# C_adz = main_module.Analysis.Models.ADZ.Concentrations
# 
# #  # Peak concentrations 
# C_advection_only_peaks = main_module.Analysis.Models.AdvectionOnly.PeakConcentrationsOverTime(y_index)
# C_ADE_1D_Peaks = main_module.Analysis.Models.ADELongitudinal.PeakConcentrationsOverTime(y_index)
# C_ADE_2D_Peaks = main_module.Analysis.Models.ADETransverse.PeakConcentrationsOverTime(y_index)
# C_ADZ_Peaks = main_module.Analysis.Models.ADZ.PeakConcentrationsOverTime(y_index)
# 
#==============================================================================
# Residuals 
#C_advection_only_peaks_residuals = main_module.Analyses.Models.


#==============================================================================
# # Plot concentrations
# plt.plot(time_values, C_advection[:,y_index,:])
# plt.xlabel('time (s)')
# plt.ylabel('Concentration (Kg/m3)')
# plt.title('Advection only')
# plt.show()
# 
# plt.plot(time_values, C_longitudinal[:,y_index,:])
# plt.xlabel('time (s)')
# plt.ylabel('Concentration (Kg/m3)')
# plt.title('ADE 1D')
# plt.show()
# 
# 
# plt.plot(time_values, C_transverse[:,y_index,:])
# plt.xlabel('time (s)')
# plt.ylabel('Concentration (Kg/m3)')
# plt.title('ADE 2D')
# plt.show()
# 
# plt.plot(time_values, C_adz[:,y_index,:])
# plt.xlabel('time (s)')
# plt.ylabel('Concentration (Kg/m3)')
# plt.title('ADZ')
# plt.show()
# 
#==============================================================================
# Plot concentrations at various X and time values
#==============================================================================
# plot_x = 50 #BE CAREFUL! 50 m downstream because deltax = 1 m 
# 
# Advection_only = plt.plot(time_values, C_advection[plot_x,y_index,:],label='Advection Only', linestyle=':')
# ADE_1D = plt.plot(time_values, C_longitudinal[plot_x,y_index,:], label='ADE 1D', linestyle='--')
# ADE_2D = plt.plot(time_values, C_transverse[plot_x,y_index,:], label='ADE 2D',linestyle='-.')
# ADZ = plt.plot(time_values, C_adz[plot_x,y_index,:], label='ADZ',linestyle='-')
# #plt.ylim(-0.2,)
# #plt.xlim(-5,100)
# plt.legend(loc=1)
# plt.xlabel('time (s)')
# plt.ylabel('Concentration (Kg/m3)')
# plt.title('Concentration %1.0f m downstream of release Coachella River' % plot_x)
#==============================================================================
#plt.show()

#==============================================================================
 
#==============================================================================
#  # Peak concentrations 
# C_advection_only_peaks = main_module.Analysis.Models.AdvectionOnly.PeakConcentrations(y_index)
# C_ADE_1D_Peaks = main_module.Analysis.Models.ADELongitudinal.PeakConcentrations(y_index)
# C_ADE_2D_Peaks = main_module.Analysis.Models.ADETransverse.PeakConcentrations(y_index)
# C_ADZ_Peaks = main_module.Analysis.Models.ADZ.PeakConcentrations(y_index)
#==============================================================================
 


#==============================================================================
# #Residuals 
# Advection_only_residuals =  C_advection_only_peaks-C_ADE_2D_Peaks
# ADE_1D_residuals = C_ADE_1D_Peaks-C_ADE_2D_Peaks
# ADE_2D_residuals = C_ADE_2D_Peaks-C_ADE_2D_Peaks
# ADZ_residuals = C_ADZ_Peaks-C_ADE_2D_Peaks
# 
# 
#  #Peak concentrations absolute differences Plot
# plt.plot(time_values,C_advection_only_peaks-C_ADE_2D_Peaks,label='Advection Only', linestyle=':')
# plt.plot(time_values,C_ADE_1D_Peaks-C_ADE_2D_Peaks, label='ADE 1D', linestyle='--')
# plt.plot(time_values,C_ADE_2D_Peaks-C_ADE_2D_Peaks, label='ADE 2D',linestyle='-.')
# plt.plot(time_values,C_ADZ_Peaks-C_ADE_2D_Peaks, label='ADZ',linestyle='-')
# plt.xlabel('Time(s)')
# plt.ylabel('Peak Concentrations Residuals')
# plt.title('Absolute Peak Concentration Residuals Coachella River')
# plt.legend(loc=4)
# #plt.xlim(0,160)
#==============================================================================
#plt.show() 
  
 
#==============================================================================
# 
#  # Find maximum of peak concentrations 
# C_advection_only_Peaks_Max = np.amax(C_advection_only_peaks)
# C_ADE_1D_Peaks_Max = np.amax(C_ADE_1D_Peaks)
# C_ADE_2D_Peaks_Max = np.amax(C_ADE_2D_Peaks)
# C_ADZ_Peaks_Max = np.amax(C_ADZ_Peaks)
# 
# #==============================================================================
# # # Plot peak concentrations vs distance
# # Advection_only_peaks = plt.plot(x_values, C_advection_only_peaks, label='Advection Only', linestyle=':')
# # ADE_1D_peaks = plt.plot(x_values, C_ADE_1D_Peaks, label='ADE 1D', linestyle='--')
# # ADE_2D_peaks = plt.plot(x_values, C_ADE_2D_Peaks, label='ADE 2D',linestyle='-.')
# # ADZ_peaks = plt.plot(x_values, C_ADZ_Peaks, label='ADZ',linestyle='-')
# # plt.legend(loc=1)
# # plt.xlabel('distance (m)')
# # plt.ylabel('Concentration (Kg/m3)')
# # plt.title('Peak concentrations')
# # plt.show()
# # 
# #  # Plot peak concentrations vs time
# # Advection_only_peaks = plt.plot(time_values, C_advection_only_peaks, label='Advection Only', linestyle=':')
# # ADE_1D_peaks = plt.plot(time_values, C_ADE_1D_Peaks, label='ADE 1D', linestyle='--')
# # ADE_2D_peaks = plt.plot(time_values, C_ADE_2D_Peaks, label='ADE 2D',linestyle='-.')
# # ADZ_peaks = plt.plot(time_values, C_ADZ_Peaks, label='ADZ',linestyle='-')
# # plt.legend(loc=1)
# # plt.xlabel('time (s)')
# # plt.ylabel('Concentration (Kg/m3)')
# # plt.title('Peak concentrations')
# # plt.show()
# #==============================================================================
#   
#  # Normalize peak concentrations 
# C_advection_only_Peaks_Normalized = C_advection_only_peaks/C_advection_only_Peaks_Max
# C_ADE_1D_Peaks_Normalized = C_ADE_1D_Peaks/C_ADE_1D_Peaks_Max
# C_ADE_2D_Peaks_Normalized = C_ADE_2D_Peaks/C_ADE_2D_Peaks_Max
# C_ADZ_Peaks_Normalized = C_ADZ_Peaks/C_ADZ_Peaks_Max
#  
#  # Plot Normalized Peak Concentrations against 1/Pe 
# t_factor = main_module.Analysis.NormalizationFactor()
# time_values_array = np.array((time_values), float)
# time_values_normalized = time_values_array * t_factor
#  
# plt.plot(time_values_normalized,C_advection_only_Peaks_Normalized,label='Advection Only', linestyle=':')
# plt.plot(time_values_normalized,C_ADE_1D_Peaks_Normalized, label='ADE 1D', linestyle='--')
# plt.plot(time_values_normalized,C_ADE_2D_Peaks_Normalized, label='ADE 2D',linestyle='-.')
# plt.plot(time_values_normalized,C_ADZ_Peaks_Normalized, label='ADZ',linestyle='-')
# plt.legend(loc=1)
# 
# plt.xlabel('1/Pe')
# plt.ylabel('Peak concentrations/Max Peak Concentration')
# plt.title('Normalized Peak Concentrations')
# plt.ylim(0,1.2)
# plt.show()
#  
#  # Plot differences between absolute concentrations 
# #main_module.PlotPeakConcentrationDeltas()
# #plt.show()
# 
#  
#  
#  
#  
#  
#  
#  # Calculate between normalized peak concentrations 
# deltas_Advection_normalized = C_advection_only_Peaks_Normalized - C_ADE_2D_Peaks_Normalized
# deltas_ADE_1D_normalized = C_ADE_1D_Peaks_Normalized - C_ADE_2D_Peaks_Normalized
# deltas_ADE_2D_normalized = C_ADE_2D_Peaks_Normalized - C_ADE_2D_Peaks_Normalized
# deltas_ADZ_normalized = C_ADZ_Peaks_Normalized - C_ADE_2D_Peaks_Normalized
#  
#  # Plot differences between normalized peak concentrations 
# plt.plot(time_values_normalized,deltas_Advection_normalized,label='Advection Only', linestyle=':')
# plt.plot(time_values_normalized,deltas_ADE_1D_normalized, label='ADE 1D', linestyle='--')
# plt.plot(time_values_normalized,deltas_ADE_2D_normalized, label='ADE 2D',linestyle='-.')
# plt.plot(time_values_normalized,deltas_ADZ_normalized, label='ADZ',linestyle='-')
# plt.xlabel('1/Pe')
# plt.ylabel('Peak normalized concentration Residuals')
# plt.title('Relative concentration Residuals')
# plt.legend(loc=1)
# #plt.xlim(1,20)
# plt.show()
# #==============================================================================
# 
# 
# 
# 
# 
#==============================================================================





